---
generated_at: 2026-01-22 14:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-Accessibility Reports

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/serializers/accessibility_reports_comparer_serializer.rb` (行4)
- E-02: `app/serializers/accessibility_reports_comparer_entity.rb` (行3-15)
- E-03: `app/models/ci/pipeline.rb` (行1340-1346)
- E-04: 帳票一覧.csv (No.17の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JSON出力形式 | E-02 (構造) | ○ |
| C-02 | AccessibilityReportsComparerEntityを使用 | E-01 (行4) | ○ |
| C-03 | statusを公開 | E-02 (行4) | ○ |
| C-04 | new_errorsを公開 | E-02 (行6) | ○ |
| C-05 | resolved_errorsを公開 | E-02 (行7) | ○ |
| C-06 | existing_errorsを公開 | E-02 (行8) | ○ |
| C-07 | AccessibilityErrorEntityでエラー詳細 | E-02 (行6-8) | ○ |
| C-08 | summaryにtotal/resolved/erroredを公開 | E-02 (行10-14) | ○ |
| C-09 | total_countを計算 | E-02 (行11) | ○ |
| C-10 | resolved_countを計算 | E-02 (行12) | ○ |
| C-11 | errors_countを計算 | E-02 (行13) | ○ |
| C-12 | pipeline.accessibility_reportsで取得 | E-03 (行1340-1346) | ○ |
| C-13 | AccessibilityReports.newで生成 | E-03 (行1341) | ○ |
| C-14 | latest_report_buildsから取得 | E-03 (行1342) | ○ |
| C-15 | of_report_type(:accessibility)でフィルタ | E-03 (行1342) | ○ |
| C-16 | collect_accessibility_reports!で収集 | E-03 (行1343) | ○ |
| C-17 | base/headパイプラインを比較 | E-02 (構造から推測) | ○ |
| C-18 | WCAG/ルールコードを含む | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠あり、コードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] MRのアクセシビリティウィジェットが表示されることを確認
- [ ] new_errors/resolved_errors/existing_errorsが正しく分類されることを確認
- [ ] summaryの数値が正しく計算されることを確認
- [ ] エラー詳細（code, message, context, selector）が表示されることを確認
